<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/ForeignTrader.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ZPNW_ZA.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Trader.xsd" xmlns:ns5="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/ForeignTrader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v6_0/Trader.xsd" xmlns:zpnwza="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v2_0/ZPNW_ZA.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="iso-8859-1" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:text>ZPNW_ZA</xsl:text></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_ZPNW_ZA" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_ZPNW_ZA"><xsl:for-each select=" ns1:Header|  ns1:* | zpnwza:*"><xsl:apply-templates mode="Ident" select="."/><xsl:apply-templates mode="rodz_dekl" select="."/><xsl:apply-templates mode="PodstawaPrawna" select="."/><xsl:apply-templates mode="MiejsceDekl" select="."/><xsl:apply-templates mode="Cel" select="."/><!--	<xsl:apply-templates mode="RodzZab" select="."/> --><xsl:apply-templates mode="DaneZglaszajacego" select="ns1:Declarant | zpnwza:Declarant  | ns4:* | tr:* | ns5:* | fr:* "/><xsl:apply-templates mode="AdresZglaszajacego" select="ns1:Declarant | zpnwza:Declarant | ns4:* | tr:* | ns5:* | fr:* "/><xsl:apply-templates mode="Reprezentant" select="."/><xsl:apply-templates mode="DaneNadawcy" select="ns1:Consignor | zpnwza:Consignor | ns4:* | tr:* | ns5:* | fr:*"/><xsl:apply-templates mode="AdresNadawcy" select="ns1:Consignor | zpnwza:Consignor | ns4:* | tr:* | ns5:* | fr:*"/><!-- <xsl:apply-templates mode="DaneReprezentanta" select="ns1:Representative | zpnw:Representative | ns4:* | tr:* | ns5:* | fr:*"/> --><xsl:apply-templates mode="MiejsceDostawy" select="."/><xsl:apply-templates mode="RodzZab" select="."/><xsl:apply-templates mode="Wyroby" select="."/><xsl:apply-templates mode="Zalacznik" select="."/><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:apply-templates mode="OswPodatnika" select="."/><!-- SZABLON DOT. ADNOTACJI--><xsl:apply-templates mode="Adnotacje" select="."/><!-- SZABLON DOT. OBJASNIENIA --><xsl:apply-templates mode="ObjasnieniaAkc" select="."/><!-- SZABLON DOT. POUCZENIA--><xsl:apply-templates mode="PouczeniaAkc" select="."/></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" valign="top"><td align="left" colspan="2" height="45" valign="middle" width="586"><span class="cz12"><b>1. Identyfikator podatkowy NIP/numer PESEL<sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup></b></span></td><td align="center" colspan="2" valign="middle" width="353"><span class="nag2"><b><xsl:value-of select="@identifier"/></b></span></td></tr><tr align="left" colspan="1" valign="top"><td align="left" height="45" valign="top" width="353"/><td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"><b>2. Nr dokumentu</b><br/><span class="cz16"><b><xsl:value-of select="@selfRef"/></b></span></td><td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"><b>3. Status</b></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:* | zpnwza:*"><table width="955"><tr><td align="center" valign="middle"><div class="cz16"><b> ZGŁOSZENIE O PLANOWANYM NABYCIU WEWNĄTRZWSPÓLNOTOWYM <br/> WYROBÓW AKCYZOWYCH INNYCH NIŻ OKREŚLONE W ZAŁĄCZNIKU NR 2 DO USTAWY <br/>Z DNIA 6 GRUDNIA 2008 R. O PODATKU AKCYZOWYM, <br/> OBJĘTYCH STAWKĄ AKCYZY INNĄ NIŻ STAWKA ZEROWA, PRZEMIESZCZANYCH NA TERYTORIUM KRAJU W RAMACH NABYCIA WEWNĄTRZWSPÓLNOTOWEGO W CELU WPROWADZENIA ICH DO SKŁADU PODATKOWEGO </b></div></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><xsl:if test="ns1:* | zpnwza:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">A. MIEJSCE SKŁADANIA</span></td></tr><tr><td bgcolor="#CCCCCC" width="50"/><td align="left" colspan="2" valign="top"><b>4. Naczelnik Urzędu Skarbowego, do którego składane jest zgłoszenie</b><br/><br/><span class="cz18"><xsl:value-of select="//@taxOffice"/></span></td></tr><!-- <tr> <td bgcolor="#CCCCCC"/> <td align="left" valign="top"> <b>5. Data wypełnienia zgłoszenia</b> (rok-miesiąc-dzień) <br/> <br/> <span class="cz18"> <xsl:value-of select="//@declarationDate"/> </span> </td> <td align="left" valign="top"> <b>6. Przewidywane miejsce i data dostawy</b> (rok-miesiąc-dzień) <br/> <br/> <span class="cz18"> <xsl:value-of select="//@expectedDeliveryPlace"/> </span> <span class="cz18"> <xsl:value-of select="//@expectedDateOfArrival"/> </span> </td> </tr> --></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSC DOSTAWY --><xsl:template match="*" mode="MiejsceDostawy"><xsl:if test="ns1:* | zpnwza:*"><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"/><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">E. MIEJSCE I DATY DOSTAWY</span></td></tr><tr><td bgcolor="#CCCCCC" width="50"/><td align="left" valign="top" width="412"><b>30. Miejsce dostawy<sup>3)</sup></b><br/><br/><span class="cz18"><xsl:value-of select="//@address"/></span><br/><span class="cz18"><xsl:value-of select="//@operatorNo"/></span></td><td align="left" valign="top"><b>31. Data dostawy/ daty dostawy</b> (rok-miesiąc-dzień) <br/><br/><xsl:for-each select="//ns1:deliveryDates"><span class="cz18"><xsl:value-of select="@deliveryDate"/><br/></span></xsl:for-each></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  CEL--><xsl:template match="*" mode="Cel"><xsl:if test="ns1:* | zpnwza:*"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="2"><span class="nag1">B. CEL ZŁOŻENIA ZGŁOSZENIA<sup>*</sup></span></td></tr><tr align="left" valign="top"><td width="472">1. złożenie zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span></xsl:if></td><td width="467">2. korekta zgłoszenia <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"><br/><span class="cz18"><b>X - </b><xsl:value-of select="@submissionAim"/></span></xsl:if></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc"><xsl:if test="ns1:* | zpnwza:*"><table border="1" width="955"><tr><td height="49" width="247"/><td align="left" valign="top" width="135"><b>4. Miesiac/Kwartal</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,6,7)"/> - <xsl:value-of select="substring(@periodTo,6,7)"/></div></td><td align="left" valign="top" width="131"><b>5. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,1,4)"/></div></td><td width="206"/><td align="left" valign="top" width="206"><br/><div align="center" class="cz18"/></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. Rodzaju zabezpieczenia --><xsl:template match="*" mode="RodzZab"><xsl:if test="ns1:* | zpnwza:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1">F. RODZAJ ZABEZPIECZENIA AKCYZOWEGO<sup>*</sup></span></td></tr><tr><td bgcolor="#CCCCCC" width="50"/><td align="left" valign="top" width="412"><b>32. Rodzaj zabezpieczenia</b><br/><xsl:for-each select="//zpnwza:Collateral | //ns1:Collateral"><br/><xsl:choose><xsl:when test="@type='JEDN'"><span class="cz18">jednorazowe</span></xsl:when><xsl:when test="@type='GEN'"><span class="cz18">generalne</span></xsl:when><xsl:when test="@type='RYCZ'"><span class="cz18">ryczałtowe</span></xsl:when><xsl:otherwise><xsl:text> ... </xsl:text></xsl:otherwise></xsl:choose></xsl:for-each></td><td align="left" valign="top" width="471"><b>33. Numer zabezpieczenia akcyzowego</b><br/><xsl:for-each select="//zpnwza:Collateral | //ns1:Collateral"><br/><span class="cz18"><xsl:value-of select="@number"/></span></xsl:for-each></td></tr><tr><td bgcolor="#CCCCCC"/><td align="left" colspan="2" valign="top"><b>34. Kwota zabezpieczenia akcyzowego w zł <sup>4) 5)</sup></b> słownie  <br/><xsl:for-each select="//zpnwza:Collateral | //ns1:Collateral"><br/><span class="cz18"><xsl:value-of select="@amountOfUse"/></span></xsl:for-each></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. Dane zglaszajacego --><xsl:template match="ns1:Declarant | zpnwza:Declarant  | ns4:* | tr:* | ns5:*  | fr:*" mode="DaneZglaszajacego"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">C. ZGŁASZAJĄCY<sup>1)</sup></span></td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">C.1 DANE IDENTYFIKACYJNE ZGŁASZAJĄCEGO </span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><b>7. Rodzaj podmiotu </b> (zaznaczyć właściwy kwadrat): </td></tr><tr><td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData  "><b><span class="cz18">X</span></b></xsl:for-each></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"><b><span class="cz18">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="3" valign="top"><b>8. Nazwa pełna podmiotu / dane osobowe (imię, nazwisko)</b><br/><br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData "><span class="cz18"><xsl:value-of select=".//@fullName"/></span><span class="cz18"><xsl:value-of select=".//@REGON"/></span></xsl:for-each><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson"><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select=".//@PESEL"/></span></xsl:for-each></td></tr></table></xsl:template><!-- SZABLON DOT. Reprezentanta --><xsl:template match="*" mode="Reprezentant"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">C.3. REPREZENTOWANY przez:</span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><br/><span class="cz18"><xsl:value-of select=".//@repFirstName"/></span><span class="cz18"><xsl:value-of select=".//@repSurname"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. Adres zglaszajacego --><xsl:template match="ns1:Declarant | zpnwza:Declarant  | ns4:* | tr:* | ns5:*  " mode="AdresZglaszajacego"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">C.2. ADRES SIEDZIBY / ADRES ZAMIESZKANIA </span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td width="269"><b>9. Kraj </b><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>10. Województwo</b><br/><span class="cz18"><xsl:value-of select=".//@provinceName"/></span></td><td colspan="2"><b>11. Powiat</b><br/><span class="cz18"><xsl:value-of select=".//@districtName"/></span></td></tr><tr align="left" valign="top"><td><b>12. Gmina </b><br/><span class="cz18"><xsl:value-of select=".//@communeName"/></span></td><td colspan="2"><b>13. Ulica</b><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>14. Nr domu</b><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>15. Nr lokalu</b><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>16. Miejscowość</b><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td width="130"><b>17. Kod pocztowy</b><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td width="181"><b>18. Poczta</b><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><td colspan="2"><b>19. Adres e-mail</b><br/><span class="cz18"><xsl:value-of select=".//@email"/>;</span><span class="cz18"><xsl:value-of select=".//@phone"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. Dane nadawcy --><xsl:template match="*" mode="DaneNadawcy"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">D. NADAWCA<sup>2)</sup></span><br/></td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">D.1 DANE IDENTYFIKACYJNE NADAWCY </span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><b>20. Rodzaj podmiotu </b>(zaznaczyć właściwy kwadrat) </td></tr><tr><td align="left" valign="top">1. podmiot niebędący osobą fizyczną<br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData "><b><span class="cz18">X</span></b></xsl:for-each></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson  | .//fr:PrivatePerson"><b><span class="cz18">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="3" valign="top"><b>21. Nazwa pełna podmiotu/ dane osobowe (imię, nazwisko, data urodzenia)/ IDENTYFIKATOR </b><br/><br/><xsl:for-each select=".//tr:TaxpayerData | .//ns4:TaxpayerData | .//fr:TaxpayerData | ns5:*"><span class="cz18"><xsl:value-of select="@fullName"/></span> / <span class="cz18"><xsl:value-of select="//@consignorId"/></span></xsl:for-each><xsl:for-each select=".//tr:PrivatePerson | .//ns4:PrivatePerson | .//fr:PrivatePerson"><span class="cz18"><xsl:value-of select=".//@firstName"/></span><span class="cz18"><xsl:value-of select=".//@surname"/></span><span class="cz18"><xsl:value-of select=".//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select=".//@PESEL"/></span> / <span class="cz18"><xsl:value-of select="//@consignorId"/></span></xsl:for-each></td></tr></table></xsl:template><!-- SZABLON DOT. Adres nadawcy --><xsl:template match="zpnwza:Consignor | ns1:Consignor | tr:* | ns4:* | ns5:* | fr:*" mode="AdresNadawcy"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">D.2. ADRES SIEDZIBY / ADRES ZAMIESZKANIA </span></td></tr><tr align="left" valign="top"><td><b>22. Kraj </b><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>23. Ulica</b><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>24. Nr domu</b><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>25. Nr lokalu</b><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>26. Miejscowość</b><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td width="130"><b>27. Kod pocztowy</b><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td width="181"><b>28. Poczta</b><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><td colspan="2"><b>29. Adres e-mail, nr telefonu</b><br/><span class="cz18"><xsl:value-of select=".//@email"/>;<xsl:value-of select=".//@phoneConsignor"/></span></td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">ZPNW_ZA</span><sub style="cz9"/><b style="nag1">(1)/1</b></td></tr></table></xsl:template><!-- SZABLON DOT. Dane Reprezentanta --><xsl:template match="zpnwza:Representative | ns1:Representative" mode="DaneReprezentanta"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="3"><span class="nag1"><b>DANE REPREZENTANTA</b></span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="2" width="46"/><td align="left" valign="top" width="413"><b>24.Imię</b><br/><br/><span class="cz18"><xsl:value-of select=".//@firstName"/></span></td><td align="left" valign="top" width="471"><b>25. Nazwisko</b><br/><br/><span class="cz18"><xsl:value-of select=".//@surname"/></span></td></tr><tr><td align="left" colspan="2" valign="top"><b>26.Numer telefonu i adres e-mail</b><br/><br/><span class="cz18"><xsl:value-of select=".//@phone"/>;<xsl:value-of select=".//@email"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. WYROBOW --><xsl:template match="ns1:* | zpnwza:*" mode="Wyroby"><!-- ZNAK KONCA STRONY DO WYDRUKU --><!-- <div style="page-break-before: always"/> --><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="6"><span class="nag1"><b>G. DANE DOTYCZĄCE WYROBÓW AKCYZOWYCH PRZEWIDYWANYCH DO NABYCIA</b></span></td></tr><tr align="center" bgcolor="#CCCCCC" valign="top"><td><span class="cz14"> Lp. </span></td><td><span class="cz14"> Opis wyrobów <sup>**</sup></span></td><td><span class="cz14"> Kod CN </span></td><td><span class="cz14">Szacowana ilość/<br/> j. m./<br/>średnia ważona /<br/> wartość wg maks. ceny detalicznej</span></td><td><span class="cz14">Stawka akcyzy <br/>kwotowa/<br/> procentowa/<br/>minimalna </span></td><td><span class="cz14">Kwota akcyzy <br/> podlegającej zawieszeniu w zł <sup>5)</sup></span></td></tr><xsl:for-each select="//zpnwza:Item | //ns1:Item"><tr><td><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="@id"/></div></td><td><div align="left" class="cz14" valign="top"><xsl:value-of select="@goodsName"/></div><div align="left" class="cz14" valign="top"><i><b><xsl:value-of select="@groupOfGoodsName"/></b></i></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@codeCN"/></div></td><td><div align="right" class="cz18"><xsl:value-of select="@valueOfGoods"/></div><div align="right" class="cz18"><xsl:value-of select="@numberOfGoods"/><br/> ______ </div><div align="right" class="cz14"><xsl:value-of select="@unitOfMeasure"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@weightedAverageRetailPrice"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@maximumRetailPriceValue"/></div></td><td><div align="right" class="cz18"><xsl:value-of select="@taxRate"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@taxRatePercentage"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@taxMin"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(@amountOfExciseSuspension),'# ##0')"/></div></td></tr></xsl:for-each><tr align="left" valign="top"><td height="48"/><td bgcolor="#CCCCCC"><b/></td><td bgcolor="#CCCCCC">-</td><td><b>Łącznie:<sup>****</sup></b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="*/@totalNumberOfGoods"/></div></td><td>- </td><td><b>Łącznie:<sup>****</sup></b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(*/@totalAmountOfExciseSuspension),'# ##0')"/></div></td></tr></table></xsl:template><!-- SZABLON DOT. WYROBOW --><!-- SZABLON DOT. ZAŁACZNIKA --><xsl:template match="*" mode="Zalacznik"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">H. ZAŁĄCZONE DOKUMENTY<sup>6)</sup></span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" valign="top"><br/><span class="cz18"><xsl:value-of select=".//@documentAttached"/></span></td></tr></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:* | zpnwza:* | tp:*"><table border="1" height="210" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><b><span class="nag1">I. OŚWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span></b><br/> Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistoscią.</td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>35. Imię </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="491"><b>36. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname "/></span></td></tr><tr align="left" valign="top"><td height="39"><b>37. Data wypełnienia zgłoszenia</b> (dzień-miesiąc-rok) <br/><br/><br/><span class="cz18"><xsl:value-of select="substring(//@declarationDate,9,2)"/><xsl:value-of select="substring(//@declarationDate,5,4)"/><xsl:value-of select="substring(//@declarationDate,1,4)"/></span></td><td><b>38. Podpis zgłaszającego lub osoby reprezentującej podatnika <sup>7)</sup></b></td></tr><tr align="left" valign="top"><td colspan="2" height="70"><b>39.Nr dowodu osobistego lub innego dokumentu stwierdzającego tożsamość oraz fakultatywnie nr telefonu i adres e-mail zgłaszającego lub osoby reprezentującej podatnika </b><br/><br/><span class="cz18"><xsl:value-of select="//@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA ZGŁOSZENIA --><xsl:template match="*" mode="PodstawaPrawna"><xsl:if test="ns1:* | zpnwza:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td align="left" valign="top" width="115">Podstawa prawna: </td><td align="left" valign="top" width="824">Art. 41 ust. 4 pkt 2 lit. a ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2019 r. poz. 864, z późn. zm.)  </td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:* | zpnwza:*"><table border="1" height="167" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="3" height="36">J. ADNOTACJE URZĘDU SKARBOWEGO </td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>40.Uwagi urzędu skarbowego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>41. Identyfikator przyjmującego formularz <br/><br/><br/></b><p/></td><td width="421"><b>42. Podpis przyjmującego formularz </b></td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">ZPNW_ZA</span><sub style="cz9"/><b style="nag1">(1)/2</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA --><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:* | zpnwza:*"><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"/><table width="955"><tr><td><br/><p align="center"> OBJAŚNIENIA</p><p> *   Właściwe zaznaczyć.</p><p> **    Wystarczające jest wskazanie rodzaju wyrobów akcyzowych, np. oleje smarowe.</p><p> ***  Należy wpisać odpowiednio łączną ilość w jednostkach miary nabywanych wewnątrzwspólnotowo wyrobów akcyzowych oraz łączną kwotę akcyzy podlegającej zawieszeniu.  </p><p><sup>1)</sup>Należy podać imię i nazwisko lub nazwę oraz adres zamieszkania lub siedziby podmiotu prowadzącego skład podatkowy, jego numer akcyzowy oraz numer identyfikacji podatkowej (NIP). </p><p><sup>2)</sup>Należy podać imię i nazwisko lub nazwę oraz adres zamieszkania lub siedziby nadawcy wyrobów akcyzowych w innym państwie członkowskim oraz jego numer identyfikacji podatkowej (NIP) albo inny numer identyfikacyjny używany w państwie zamieszkania lub siedziby.</p><p><sup>3)</sup>Należy podać adres i  numer akcyzowy składu podatkowego, do którego wyroby będą wprowadzone.</p><p><sup>4)</sup>Kwota zabezpieczenia akcyzowego obejmuje mogące powstać zobowiązanie/zobowiązania  podatkowe albo mogące powstać zobowiązanie/zobowiązania podatkowe oraz opłatę paliwową, której obowiązek zapłaty może powstać.</p><p><sup>5)</sup>Kwotę zabezpieczenia akcyzowego i kwotę akcyzy podlegającej zawieszeniu zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2019 r. poz. 900, z późn. zm.).</p><p><sup>6)</sup>Należy uzupełnić, jeżeli zgłaszający dołącza dokumenty do zgłoszenia.</p><p><sup>7)</sup>W przypadku złożenia zgłoszenia w wersji elektronicznej zgłoszenie to powinno być opatrzone podpisem elektronicznym weryfikowanym przy pomocy certyfikatu celnego albo innym podpisem elektronicznym zapewniającym autentyczność deklaracji i podań, zgodnie z rozporządzeniem Ministra Rozwoju i Finansów z dnia 19 września 2017 r. w sprawie sposobu przesyłania deklaracji i podań oraz rodzajów podpisu elektronicznego, którymi powinny być opatrzone (Dz. U. poz. 1802, z późn. zm.).</p></td></tr></table></xsl:if></xsl:template><!-- KONIEC all AG--></xsl:stylesheet>